//
//  AHKPhone_Mail.m
//  AH-K3001V Utilities
//
//  Created by FUJIDANA on 06/04/26.
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.//
//

#import "AHKPhone_Mail.h"
#import "AHKMail.h"
#import "AHKProgressing.h"

@implementation AHKPhone (Mail)

- (BOOL)readMails:(NSArray **)mails password:(NSString *)password progress:(id <AHKProgressing>)progress error:(NSError **)errorPtr
{
	UInt8 buffer[kReadBufferSize];
	
	// begin progress
	[progress beginProgressWithMessage:NSLocalizedStringFromTable(@"Sending Password...", @"AHKMLocalizable", @"phone.message.password")];
	
	// log in.
	if ([self openError:errorPtr] == NO) goto ERROR;
	if ([self loginWithPassword:password error:errorPtr] == NO) goto ERROR;
	
	// count number of light-mails	
	if ([self sendCommand:2 subCommand:0x0401 parameter:"" error:errorPtr] == NO) goto ERROR;
	if ([self receiveData:buffer maxLength:sizeof(buffer) additionally:YES error:errorPtr] == -1) goto ERROR;
	const int count = atoi((char *)buffer + 12);
	
	NSMutableArray *lightMails = [NSMutableArray arrayWithCapacity:count];
	[progress startDeterminateProgressWithMaxValue:count message:NSLocalizedStringFromTable(@"Receiving Light-mails...", @"AHKMLocalizable", @"phone.message.readLightMails")];
	
	if(count > 0) {
		// begin to read light-mails
		if ([self sendCommand:3 subCommand:0x0402 parameter:"" error:errorPtr] == NO) goto ERROR;
		
		int n;
		for (n = 0; n < count; n++) {
			// Now safe to abort communication, so check whether user requested to abort progress
			if ([progress isRequestedToAbort]) {
				if (errorPtr) {
					NSDictionary *userInfo = [NSDictionary dictionaryWithObject:NSLocalizedStringFromTable(@"Reading Mails was interrupted by user. The database of your computer is not updated.", @"AHKMLocalizable", @"error.userCancelledWhileReadingMails.description")
																		 forKey:NSLocalizedDescriptionKey];
					*errorPtr = [NSError errorWithDomain:AHKErrorDomain
													code:AHKPhoneUserCancelledError
												userInfo:userInfo];
				}
				goto ERROR;
			}
			
			// Read a light-mail
			if ([self receiveData:buffer maxLength:sizeof(buffer) additionally:YES error:errorPtr] == -1) goto ERROR;
			if (buffer[3] != 0x03 || buffer[9] != 0x04 || buffer[11] != 0x02) {
				if (errorPtr) {
					NSDictionary *userInfo = [NSDictionary dictionaryWithObject:NSLocalizedStringFromTable(@"Illegal format data were found in receiving a light-mail.", @"AHKMLocalizable", @"error.InapplicableLightMailDataReceived.description")
																		 forKey:NSLocalizedDescriptionKey];
					*errorPtr = [NSError errorWithDomain:AHKErrorDomain
													code:AHKPhoneInapplicableDataReceivedError
												userInfo:userInfo];
				}
				goto ERROR;
//				[NSException raise:kAirHPhoneException format:@"Illegal format data were found in recieving light-mails."];
			}
			// Notify that reading has been finished
			if ([self sendCommand:0x10 subCommand:0x0910 parameter:"0" error:errorPtr] == NO) goto ERROR;
			
			// Parse light-mail data obtained above
			UInt8 *fields[4] = { NULL, NULL, NULL, NULL };
			UInt8 *p         = buffer + 13;
			while (p[1] >= 1 && p[1] <= 4) {
				UInt8  *field       = p + 7;
				SInt32  fieldLength = p[3] + (p[4] << 8) + (p[5] << 16) + (p[6] << 24);
				SInt32  fieldIndex  = p[1] - 1;
				if (fieldLength == 0x01000000) {
					fieldLength = p[2];
				}
				fields[fieldIndex] = field;
				p = field + fieldLength;
				*p = 0;
				
				if (fields[0] != NULL && fields[1] != NULL && fields[2] != NULL && fields[3] != NULL) {
					field		= p + 7;
					fieldLength	= p[3] + (p[4] << 8) + (p[5] << 16) + (p[6] << 24);
					p			= field + fieldLength;
					NSString *dateString = [[[NSString alloc] initWithBytes:field
																	 length:fieldLength
																   encoding:NSShiftJISStringEncoding] autorelease];
					
					field		= p + 7;
					fieldLength	= p[3] + (p[4] << 8) + (p[5] << 16) + (p[6] << 24);
					p			= field + fieldLength;
					NSString *object = [[[NSString alloc] initWithBytes:field
																	 length:fieldLength
																   encoding:NSShiftJISStringEncoding] autorelease];
					
					field		= p + 7;
					fieldLength	= p[3] + (p[4] << 8) + (p[5] << 16) + (p[6] << 24);
					p			= field + fieldLength;
					NSData *lightMailData = [NSData dataWithBytes:field length:fieldLength];
					
					AHKLightMail *mail = [[AHKLightMail alloc] initWithData:lightMailData
																		box:atoi((char *)fields[0])
																	 number:atoi((char *)fields[1])
																	 status:atoi((char *)fields[2])
																  isSecured:(BOOL)(strcmp((char *)fields[3], "ON") == 0)
																	 object:object
																 dateString:dateString];
					[lightMails addObject:mail];
					[mail release];
					break;
				}
			}
			// refresh progress indicator
			[progress incrementProgressBarBy:1];
		}
	}
	[progress endProgress];
	[progress beginProgressWithMessage:nil];
	
	// count number of emails
	if ([self sendCommand:2 subCommand:0x0501 parameter:"" error:errorPtr] == NO) goto ERROR;
	if ([self receiveData:buffer maxLength:sizeof(buffer) additionally:YES error:errorPtr] == -1) goto ERROR;
	const int count2 = atoi((char *)buffer + 12);
	
	NSMutableArray *emails = [NSMutableArray arrayWithCapacity:count2];	
	[progress startDeterminateProgressWithMaxValue:count2 message:NSLocalizedStringFromTable(@"Receiving Emails...", @"AHKMLocalizable", @"phone.message.emails")];
	
	if(count2 > 0) {
		// begin to read emails
		if ([self sendCommand:3 subCommand:0x0502 parameter:"" error:errorPtr] == NO) goto ERROR;
		
		int n;
		for (n = 0; n < count2; n++) {
			// Now safe to abort communication, so check whether user requested to abort progress
			if ([progress isRequestedToAbort]) {
				if (errorPtr) {
					NSDictionary *userInfo = [NSDictionary dictionaryWithObject:NSLocalizedStringFromTable(@"Reading Mails was interrupted by user. The database of your computer is not updated.", @"AHKMLocalizable", @"error.userCancelledWhileReadingMails.description")
																		 forKey:NSLocalizedDescriptionKey];
					*errorPtr = [NSError errorWithDomain:AHKErrorDomain
													code:AHKPhoneUserCancelledError
												userInfo:userInfo];
				}
				goto ERROR;
			}
			
			// Read a email
			SInt32 restBytes = [self receiveData:buffer maxLength:sizeof(buffer) additionally:YES error:errorPtr];
			if (restBytes == -1) goto ERROR;
			if(buffer[3] != 0x03 || buffer[9] != 0x05 || buffer[11] != 0x02) {
				if (errorPtr) {
					NSDictionary *userInfo = [NSDictionary dictionaryWithObject:NSLocalizedStringFromTable(@"Illegal format data were found in receiving an email.", @"AHKMLocalizable", @"error.InapplicableEmailDataReceived.description")
																		 forKey:NSLocalizedDescriptionKey];
					*errorPtr = [NSError errorWithDomain:AHKErrorDomain
													code:AHKPhoneInapplicableDataReceivedError
												userInfo:userInfo];
				}
				goto ERROR;
				// @"Illegal format data were found in recieving emails."
			}
			if ([self sendCommand:0x10 subCommand:0x0910 parameter:"0" error:errorPtr] == NO) goto ERROR;
			
			// Parse email data
			UInt8 *fields[4] = { NULL, NULL, NULL, NULL };
			UInt8 *p         = buffer + 13;
			while (p[1] >= 1 && p[1] <= 4) {
				UInt8  *field       = p + 7;
				SInt32  fieldLength = p[3] + (p[4] << 8) + (p[5] << 16) + (p[6] << 24);
				SInt32  fieldIndex  = p[1] - 1;
				if (fieldLength == 0x01000000) {
					fieldLength = p[2];
				}
				fields[fieldIndex] = field;
				p = field + fieldLength;
				*p = 0;
				
				if (fields[0] != NULL && fields[1] != NULL && fields[2] != NULL && fields[3] != NULL) {
					// When end reading every field, make a new email instance and add it into the list.
					
					int		box		= atoi((char *)fields[0]);
					int		number	= atoi((char *)fields[1]);
					int		status	= atoi((char *)fields[2]);
					BOOL	flag	= (BOOL)(strcmp((char *)fields[3], "ON") == 0);
					
					NSMutableData *mailData = [NSMutableData dataWithCapacity:restBytes];
					
					p += 7;
					fieldLength = kReadBufferSize;
					if (restBytes < (int)fieldLength) {
						fieldLength = restBytes;
					}
					restBytes -= fieldLength;
					fieldLength -= p - (UInt8 *)buffer;
					
					[mailData appendBytes:p length:fieldLength];
					
					while (restBytes > 0) {
						const SInt32 numBytes = [self receiveRawData:buffer maxLength:(SInt32)sizeof(buffer) error:errorPtr];
						if (numBytes == -1) goto ERROR;
						restBytes -= numBytes;
						[mailData appendBytes:buffer length:numBytes];
					}
					
					AHKEmail *mail = [[AHKEmail alloc] initWithData:mailData
																box:box
															 number:number
															 status:status
														  isSecured:flag];
					[emails addObject:mail];
					[mail release];
					//[self sendCommand:0x10 subCommand:0x0910 parameter:"0"];
					break;
				}
			}
			//[self sendCommand:0x10 subCommand:0x0910 parameter:"0"];
			
			// refresh progress window.
			[progress incrementProgressBarBy:1];
		}
	}
	[progress endProgress];
	[self closeError:errorPtr];
	*mails = [lightMails arrayByAddingObjectsFromArray:emails];
	return YES;

ERROR:
	[progress endProgress];
	[self closeError:NULL];
	return NO;
}

- (BOOL)writeMails:(NSArray *)array withPassword:(NSString *)password progress:(id <AHKProgressing>)progress
{
	return NO;
}

@end
